/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.client;

import com.ibm.hsc.cim.client.HSCCECCIMClient;
import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HscUtil;
import com.ibm.hsc.websm.cec.CECMObject;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.mobject.MOClass;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class CuodActions {
    public static final String CUOD_PROCESSOR_INFO = "CUoDProcessorInfo";
    public static final String PROCESSOR_INFO = "processorInfo";
    public static final String CUOD_MEMORY_INFO = "CUoDMemoryInfo";
    public static final String MEMORY_INFO = "memoryInfo";
    public static final String MOF_SET_CUOD_KEY = "SetCUoDKey";
    public static final String MOF_ACCEPT_CUOD_AGREEMENT = "AcceptCUoDAgreement";
    public static final String MOF_ACCEPT_VALUE = "acceptValue";
    public static final String MOF_ACTIVATION_KEY = "activationKey";
    public static final String MOF_NUM_PROCS_TO_ACTIVATE = "numOfProcs";
    public static final String MOF_AMOUNT_MEMORY_TO_ACTIVATE = "amountOfMemory";
    public static final String MOF_CUOD_PROCESSOR_ACTIVATE_IMMEDIATE = "CUoDProcessorActivateImmediate";
    public static final String MOF_CUOD_MEMORY_ACTIVATE_IMMEDIATE = "CUoDMemoryActivateImmediate";
    public static final String MOF_CUOD_DISABLE_PROCESSOR_ACTIVATE_IMMEDIATE = "CUoDDisableProcessorActivateImmediate";
    public static final String MOF_CUOD_DISABLE_MEMORY_ACTIVATE_IMMEDIATE = "CUoDDisableMemoryActivateImmediate";
    public static final String MOF_MANAGE_ONOFF_COD_PROCESSORS = "ManageOnOffCoDProcessors";
    public static final String MOF_GET_ONOFF_PROCESSOR_INFO = "OnOffProcessorInfo";
    private HSCCECCIMClient cecClient;
    private CIMObjectPath cecPath;
    private static CuodActions inst;
    private String activationKey;
    private String cecName;
    private String hostName;

    protected CuodActions(HSCCECCIMClient hSCCECCIMClient) {
        this.cecClient = hSCCECCIMClient;
        if (hSCCECCIMClient != null) {
            this.hostName = hSCCECCIMClient.getHostName();
            this.cecName = hSCCECCIMClient.getIntName();
            this.cecPath = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscV3_2");
            this.cecPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            this.cecPath.addKey("Name", new CIMValue((Object)this.cecName));
        }
    }

    public static CuodActions getInstance(HSCCECCIMClient hSCCECCIMClient) {
        if (null == inst) {
            inst = new CuodActions(hSCCECCIMClient);
        }
        return inst;
    }

    private String getCECName() {
        return this.cecName;
    }

    public static CuodActions getCuodInstance(HSCCECCIMClient hSCCECCIMClient) {
        if (null == inst) {
            inst = new CuodActions(hSCCECCIMClient);
        } else if (!hSCCECCIMClient.getIntName().equals(inst.getCECName())) {
            inst = new CuodActions(hSCCECCIMClient);
        }
        return inst;
    }

    public void clickToAccept(int n) throws HSCException {
        Object var2_2 = null;
        if (IDebug.enabled) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("CUoDObject - clickToAccept");
            System.out.println("\tacceptVal = " + n);
        }
        try {
            try {
                this._clickToAccept(n);
                try {
                    MOClass mOClass = CECMObject.getMOClassProxy((String)"com.ibm.hsc.websm.cec.CECMObject");
                    String string = "CUoD license agreement has been accepted successfully";
                    HSCLogUtils.logSystemEvent((short)2077, string, new String[0], HSCLogUtils.getUserName(mOClass));
                }
                catch (Throwable throwable) {
                }
                Object var7_10 = null;
                if (IDebug.enabled) {
                    System.out.print("********************************");
                    System.out.println("********************************");
                }
            }
            catch (Throwable throwable) {
                try {
                    MOClass mOClass = CECMObject.getMOClassProxy((String)"com.ibm.hsc.websm.cec.CECMObject");
                    String string = "Failed to accept CUoD license agreement.";
                    HSCLogUtils.logSystemEvent((short)2078, string, new String[0], HSCLogUtils.getUserName(mOClass));
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                try {
                    HSCLogUtils.clientLog(throwable, HSCLogUtils._CECClassLogInfo);
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                throw new HSCException(throwable);
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (IDebug.enabled) {
                System.out.print("********************************");
                System.out.println("********************************");
            }
            throw throwable;
        }
    }

    public Hashtable processorInfo() throws HSCException {
        Vector vector = new Vector();
        Vector vector2 = new Vector(1);
        Hashtable hashtable = new Hashtable();
        Object var4_4 = null;
        if (IDebug.enabled) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("CUoDObject - processorInfo");
        }
        try {
            block14: {
                try {
                    Object object;
                    this._processorInfo(hashtable);
                    try {
                        object = CECMObject.getMOClassProxy((String)"com.ibm.hsc.websm.cec.CECMObject");
                        String string = "CUoD processor capacity setting information has been gathered successfully.";
                        HSCLogUtils.logSystemEvent((short)2079, string, new String[0], HSCLogUtils.getUserName((MOClass)object));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!IDebug.enabled) break block14;
                    System.out.println("\treturnHashtable :");
                    object = hashtable.keys();
                    while (object.hasMoreElements()) {
                        var4_4 = object.nextElement();
                        System.out.println("\t\t" + var4_4 + " --> " + hashtable.get(var4_4));
                    }
                }
                catch (Throwable throwable) {
                    try {
                        String string = "Failed to gather CUoD processor capacity setting information.";
                        HSCLogUtils.logSystemEvent((short)2080, string, new String[0], HSCLogUtils.getUserName((MOClass)CECMObject.getMOClassImpl((String)"com.ibm.hsc.websm.cec.CECMObject")));
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    try {
                        HSCLogUtils.clientLog(throwable, HSCLogUtils._CECClassLogInfo);
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                    throw new HSCException(throwable);
                }
            }
            Object var8_12 = null;
            if (IDebug.enabled) {
                System.out.print("********************************");
                System.out.println("********************************");
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (IDebug.enabled) {
                System.out.print("********************************");
                System.out.println("********************************");
            }
            throw throwable;
        }
        return hashtable;
    }

    public Hashtable cuodCPUOrderInfo() throws HSCException {
        Hashtable hashtable = new Hashtable();
        Object var2_2 = null;
        if (IDebug.enabled) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("CUoDObject - cuodCPUOrderInfo");
        }
        try {
            block14: {
                try {
                    Object object;
                    this._cuodCPUOrderInfo(hashtable);
                    try {
                        object = "CUoD processor order information has been gathered successfully.";
                        MOClass mOClass = CECMObject.getMOClassProxy((String)"com.ibm.hsc.websm.cec.CECMObject");
                        HSCLogUtils.logSystemEvent((short)2081, (String)object, new String[0], HSCLogUtils.getUserName(mOClass));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!IDebug.enabled) break block14;
                    System.out.println("\treturnHashtable :");
                    object = hashtable.keys();
                    while (object.hasMoreElements()) {
                        var2_2 = object.nextElement();
                        System.out.println("\t\t" + var2_2 + " --> " + hashtable.get(var2_2));
                    }
                }
                catch (Throwable throwable) {
                    try {
                        String string = "Failed to gather CUoD processor order information.";
                        MOClass mOClass = CECMObject.getMOClassProxy((String)"com.ibm.hsc.websm.cec.CECMObject");
                        HSCLogUtils.logSystemEvent((short)2082, string, new String[0], HSCLogUtils.getUserName(mOClass));
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    try {
                        HSCLogUtils.clientLog(throwable, HSCLogUtils._CECClassLogInfo);
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                    throw new HSCException(throwable);
                }
            }
            Object var7_10 = null;
            if (IDebug.enabled) {
                System.out.print("********************************");
                System.out.println("********************************");
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (IDebug.enabled) {
                System.out.print("********************************");
                System.out.println("********************************");
            }
            throw throwable;
        }
        return hashtable;
    }

    public void setActivateKey(String string) throws HSCException {
        Object var2_2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        if (IDebug.enabled) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("CUoDObject - setActivateKey");
            System.out.println("\tactivateKey = " + string);
        }
        try {
            try {
                this._setActivateKey(string);
                try {
                    String string2 = "CUoD activation key has been sent down successfully.";
                    MOClass mOClass = CECMObject.getMOClassProxy((String)"com.ibm.hsc.websm.cec.CECMObject");
                    HSCLogUtils.logSystemEvent((short)2083, string2, new String[0], HSCLogUtils.getUserName(mOClass));
                }
                catch (Throwable throwable) {
                }
                Object var8_12 = null;
                if (IDebug.enabled) {
                    System.out.print("********************************");
                    System.out.println("********************************");
                }
            }
            catch (Throwable throwable) {
                try {
                    String string3 = "Failed to set the CUoD activation key.";
                    HSCLogUtils.logSystemEvent((short)2084, string3, new String[0], HSCLogUtils.getUserName((MOClass)CECMObject.getMOClassImpl((String)"com.ibm.hsc.websm.cec.CECMObject")));
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                try {
                    HSCLogUtils.clientLog(throwable, HSCLogUtils._CECClassLogInfo);
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                throw new HSCException(throwable);
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (IDebug.enabled) {
                System.out.print("********************************");
                System.out.println("********************************");
            }
            throw throwable;
        }
    }

    public void activateImmedCPU(Integer n) throws HSCException {
        if (IDebug.enabled) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("CUoDObject - activateImmedCPU");
            System.out.println("\tactivateKey = " + n);
        }
        try {
            try {
                this._activateImmedCPU(n);
                try {
                    String string = "Number of Immediate CPUs has been set.";
                    MOClass mOClass = CECMObject.getMOClassProxy((String)"com.ibm.hsc.websm.cec.CECMObject");
                    HSCLogUtils.logSystemEvent((short)2087, string, new String[0], HSCLogUtils.getUserName(mOClass));
                }
                catch (Throwable throwable) {
                }
                Object var5_9 = null;
                if (IDebug.enabled) {
                    System.out.print("********************************");
                    System.out.println("********************************");
                }
            }
            catch (Throwable throwable) {
                try {
                    String string = "Failed to set the Immediate CPUS.";
                    HSCLogUtils.logSystemEvent((short)2088, string, new String[0], HSCLogUtils.getUserName((MOClass)CECMObject.getMOClassImpl((String)"com.ibm.hsc.websm.cec.CECMObject")));
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                try {
                    HSCLogUtils.clientLog(throwable, HSCLogUtils._CECClassLogInfo);
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                throw new HSCException(throwable);
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            if (IDebug.enabled) {
                System.out.print("********************************");
                System.out.println("********************************");
            }
            throw throwable;
        }
    }

    public void disableActivateImmedCPU() throws HSCException {
        if (IDebug.enabled) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("CUoDObject - disable activateImmedCPU");
        }
        try {
            try {
                this._disableActivateImmedCPU();
                try {
                    String string = "Disabled Immediate CPUs";
                    MOClass mOClass = CECMObject.getMOClassProxy((String)"com.ibm.hsc.websm.cec.CECMObject");
                    HSCLogUtils.logSystemEvent((short)2089, string, new String[0], HSCLogUtils.getUserName(mOClass));
                }
                catch (Throwable throwable) {
                }
                Object var4_8 = null;
                if (IDebug.enabled) {
                    System.out.print("********************************");
                    System.out.println("********************************");
                }
            }
            catch (Throwable throwable) {
                try {
                    String string = "Failed to set the disable Immediate CPUS.";
                    HSCLogUtils.logSystemEvent((short)2090, string, new String[0], HSCLogUtils.getUserName((MOClass)CECMObject.getMOClassImpl((String)"com.ibm.hsc.websm.cec.CECMObject")));
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                try {
                    HSCLogUtils.clientLog(throwable, HSCLogUtils._CECClassLogInfo);
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                throw new HSCException(throwable);
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            if (IDebug.enabled) {
                System.out.print("********************************");
                System.out.println("********************************");
            }
            throw throwable;
        }
    }

    public void saveMemOrderInfo(Hashtable hashtable, int n, Hashtable hashtable2) {
    }

    public void activateImmedMemory(Integer n) throws HSCException {
        if (IDebug.enabled) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("CuodActions - disable activateImmedCPU");
        }
        try {
            try {
                this._activateImmedMemory(n);
                try {
                    String string = "Amount of Immediate Memory has been set.";
                    MOClass mOClass = CECMObject.getMOClassProxy((String)"com.ibm.hsc.websm.cec.CECMObject");
                    HSCLogUtils.logSystemEvent((short)2091, string, new String[0], HSCLogUtils.getUserName(mOClass));
                }
                catch (Throwable throwable) {
                }
                Object var5_9 = null;
                if (IDebug.enabled) {
                    System.out.print("********************************");
                    System.out.println("********************************");
                }
            }
            catch (Throwable throwable) {
                try {
                    String string = "Failed to set the Immediate Memory.";
                    HSCLogUtils.logSystemEvent((short)2092, string, new String[0], HSCLogUtils.getUserName((MOClass)CECMObject.getMOClassImpl((String)"com.ibm.hsc.websm.cec.CECMObject")));
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                try {
                    HSCLogUtils.clientLog(throwable, HSCLogUtils._CECClassLogInfo);
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                throw new HSCException(throwable);
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            if (IDebug.enabled) {
                System.out.print("********************************");
                System.out.println("********************************");
            }
            throw throwable;
        }
    }

    public void disableActivateImmedMem() throws HSCException {
        if (IDebug.enabled) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("CuodActions - disable activateImmedCPU");
        }
        try {
            try {
                this._disableActivateImmedMemory();
                try {
                    String string = "Memory Activate immediate has been disabled";
                    MOClass mOClass = CECMObject.getMOClassProxy((String)"com.ibm.hsc.websm.cec.CECMObject");
                    HSCLogUtils.logSystemEvent((short)2093, string, new String[0], HSCLogUtils.getUserName(mOClass));
                }
                catch (Throwable throwable) {
                }
                Object var4_8 = null;
                if (IDebug.enabled) {
                    System.out.print("********************************");
                    System.out.println("********************************");
                }
            }
            catch (Throwable throwable) {
                try {
                    String string = "Failed to disable Memory Activate immediate";
                    HSCLogUtils.logSystemEvent((short)2094, string, new String[0], HSCLogUtils.getUserName((MOClass)CECMObject.getMOClassImpl((String)"com.ibm.hsc.websm.cec.CECMObject")));
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                try {
                    HSCLogUtils.clientLog(throwable, HSCLogUtils._CECClassLogInfo);
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                throw new HSCException(throwable);
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            if (IDebug.enabled) {
                System.out.print("********************************");
                System.out.println("********************************");
            }
            throw throwable;
        }
    }

    public Hashtable onoffProcessorInfo() throws HSCException {
        Vector vector = new Vector();
        Vector vector2 = new Vector(1);
        Hashtable hashtable = new Hashtable();
        Object var4_4 = null;
        if (IDebug.enabled) {
            System.out.println("CuodActions - onoffProcessorInfo");
        }
        try {
            block14: {
                try {
                    Object object;
                    this._onoffProcessorInfo(hashtable);
                    try {
                        object = CECMObject.getMOClassProxy((String)"com.ibm.hsc.websm.cec.CECMObject");
                        String string = "CUoD processor capacity setting information has been gathered successfully.";
                        HSCLogUtils.logSystemEvent((short)2172, string, new String[0], HSCLogUtils.getUserName((MOClass)object));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!IDebug.enabled) break block14;
                    System.out.println("\treturnHashtable :");
                    object = hashtable.keys();
                    while (object.hasMoreElements()) {
                        var4_4 = object.nextElement();
                        System.out.println("\t\t" + var4_4 + " --> " + hashtable.get(var4_4));
                    }
                }
                catch (Throwable throwable) {
                    try {
                        String string = "Failed to gather CUoD processor capacity setting information.";
                        HSCLogUtils.logSystemEvent((short)2173, string, new String[0], HSCLogUtils.getUserName((MOClass)CECMObject.getMOClassImpl((String)"com.ibm.hsc.websm.cec.CECMObject")));
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    try {
                        HSCLogUtils.clientLog(throwable, HSCLogUtils._CECClassLogInfo);
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                    throw new HSCException(throwable);
                }
            }
            Object var8_12 = null;
            if (IDebug.enabled) {
                System.out.print("********************************");
                System.out.println("********************************");
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (IDebug.enabled) {
                System.out.print("********************************");
                System.out.println("********************************");
            }
            throw throwable;
        }
        return hashtable;
    }

    public void manageOnOffCoDProcessors(Integer n) throws HSCException {
        if (IDebug.enabled) {
            System.out.println("CUoDObject - manage On/Off CoD Processors");
        }
        try {
            this._manageOnOffCoDCPUs(n);
            try {
                String string = "Manage On/Off CoD Processors";
                MOClass mOClass = CECMObject.getMOClassProxy((String)"com.ibm.hsc.websm.cec.CECMObject");
                HSCLogUtils.logSystemEvent((short)2170, string, new String[0], HSCLogUtils.getUserName(mOClass));
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            try {
                String string = "Failed to set the manage On/Off CoD CPUS.";
                HSCLogUtils.logSystemEvent((short)2171, string, new String[0], HSCLogUtils.getUserName((MOClass)CECMObject.getMOClassImpl((String)"com.ibm.hsc.websm.cec.CECMObject")));
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            try {
                HSCLogUtils.clientLog(throwable, HSCLogUtils._CECClassLogInfo);
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
            throw new HSCException(throwable);
        }
    }

    private void _processorInfo(Hashtable hashtable) throws HSCException {
        Vector vector = new Vector();
        Vector vector2 = new Vector(1);
        String[] stringArray = new String[]{};
        try {
            HscUtil.invokeCIMMethod(this.hostName, this.cecPath, CUOD_PROCESSOR_INFO, vector, vector2);
            stringArray = ((Vector)((CIMProperty)vector2.firstElement()).getValue().getValue()).toArray(stringArray);
            hashtable.put("CUOD_NUM_CPU_INSTALLED", stringArray[0]);
            hashtable.put("CUOD_NUM_CPU_PER_IN_USED", stringArray[1]);
            hashtable.put("CUOD_NUM_CPU_IMMED_IN_USED", stringArray[3]);
            hashtable.put("CUOD_NUM_CPU_NOT_PER_IN_USED", stringArray[2]);
            hashtable.put("CUOD_CPU_ACT_IMMED_CONDITION", stringArray[4]);
            hashtable.put("CUOD_CPU_ACT_IMMED_TIME_REMAINING", stringArray[5]);
            hashtable.put("CUOD_CPU_RESOURCE_ID", stringArray[6]);
            hashtable.put("CUOD_CPU_SEQ_NUM", stringArray[7]);
            hashtable.put("CUOD_CPU_ENTRY_CHECK", stringArray[8]);
            hashtable.put("CUOD_CAPACITY_CARD_CCIN", stringArray[9]);
            hashtable.put("CUOD_CAPACITY_CARD_SERIAL_NUM", stringArray[10]);
            hashtable.put("CUOD_CAPACITY_CARD_UNIQUE_ID", stringArray[11]);
            hashtable.put("CUOD_SYSTEM_SERIAL_NUM", stringArray[12]);
            hashtable.put("CUOD_SYSTEM_TYPE", stringArray[13]);
            hashtable.put("CUOD_CPU_ACTIVATED", stringArray[14]);
            hashtable.put("CUOD_PROCESSOR_INCREMENT", stringArray[15]);
            if (HscUtil.isOnOffCapable(this.hostName, this.cecPath)) {
                hashtable.put("CUOD_ONOFF_PROCS_IN_USE", stringArray[17]);
                hashtable.put("CUOD_ONOFF_PROCS_PENDING", stringArray[18]);
            }
        }
        catch (Throwable throwable) {
            if (IDebug.enabled) {
                throwable.printStackTrace();
            }
            throw new HSCException(throwable);
        }
    }

    private void _cuodCPUOrderInfo(Hashtable hashtable) throws HSCException {
        this._processorInfo(hashtable);
    }

    private void _setActivateKey(String string) throws Throwable {
        Vector<CIMProperty> vector = new Vector<CIMProperty>(1);
        Vector vector2 = new Vector();
        vector.setSize(1);
        vector.setElementAt(new CIMProperty(MOF_ACTIVATION_KEY, new CIMValue((Object)string)), 0);
        HscUtil.invokeCIMMethod(this.hostName, this.cecPath, MOF_SET_CUOD_KEY, vector, vector2);
    }

    private void _clickToAccept(int n) throws Throwable {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        vector.setSize(1);
        vector.setElementAt(new CIMProperty(MOF_ACCEPT_VALUE, new CIMValue((Object)new UnsignedInt8((short)n))), 0);
        HscUtil.invokeCIMMethod(this.hostName, this.cecPath, MOF_ACCEPT_CUOD_AGREEMENT, vector, vector2);
    }

    public short doCUOD() throws HSCException {
        CIMInstance cIMInstance = null;
        try {
            cIMInstance = HscUtil.getCIMInstance(this.hostName, this.cecPath, false);
            Vector<CIMProperty> vector = new Vector<CIMProperty>();
            vector.addElement(new CIMProperty(MOF_ACTIVATION_KEY, new CIMValue((Object)this.activationKey)));
            Vector vector2 = new Vector();
            CIMValue cIMValue = HscUtil.invokeCIMMethod(this.hostName, this.cecPath, MOF_SET_CUOD_KEY, vector, vector2);
        }
        catch (Throwable throwable) {
            System.err.println("Exception running CUOD operation");
            this._printException(throwable);
            try {
                HSCLogUtils.clientLog(throwable, HSCLogUtils._CECClassLogInfo);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw new HSCException(throwable);
        }
        return 0;
    }

    private void _printException(Throwable throwable) {
        if (IDebug.enabled()) {
            System.out.println("in printException, t = " + throwable);
        }
        if (throwable instanceof HSCCIMException) {
            String string = ((HSCCIMException)((Object)throwable)).getMessage();
            if (string != null) {
                System.err.println(string);
            }
        } else {
            System.err.println(throwable);
            if (IDebug.enabled()) {
                throwable.printStackTrace();
            }
        }
    }

    public Hashtable memoryInfo() throws HSCException {
        Vector vector = new Vector();
        Vector vector2 = new Vector(1);
        Hashtable hashtable = new Hashtable();
        Object var4_4 = null;
        if (IDebug.enabled) {
            IDebug.println((String)"In Method GET INFO ");
        }
        try {
            Object object;
            this._memoryInfo(hashtable);
            try {
                object = CECMObject.getMOClassProxy((String)"com.ibm.hsc.websm.cec.CECMObject");
                String string = "CUoD Memory capacity setting information has been gathered successfully.";
                HSCLogUtils.logSystemEvent((short)2095, string, new String[0], HSCLogUtils.getUserName((MOClass)object));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (IDebug.enabled) {
                IDebug.println((String)"\treturnHashtable :");
                object = hashtable.keys();
                while (object.hasMoreElements()) {
                    var4_4 = object.nextElement();
                    IDebug.println((String)("\t\t" + var4_4 + " --> " + hashtable.get(var4_4)));
                }
            }
        }
        catch (Throwable throwable) {
            try {
                String string = "Failed to gather CUoD memory capacity setting information.";
                HSCLogUtils.logSystemEvent((short)2096, string, new String[0], HSCLogUtils.getUserName((MOClass)CECMObject.getMOClassImpl((String)"com.ibm.hsc.websm.cec.CECMObject")));
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            try {
                HSCLogUtils.clientLog(throwable, HSCLogUtils._CECClassLogInfo);
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
            throw new HSCException(throwable);
        }
        return hashtable;
    }

    public Hashtable cuodMemoryOrderInfo() throws HSCException {
        Hashtable hashtable = new Hashtable();
        Object var2_2 = null;
        try {
            block14: {
                try {
                    Object object;
                    if (IDebug.enabled) {
                        System.out.println("\tCIMClient connection established");
                    }
                    this._cuodMemoryOrderInfo(hashtable);
                    try {
                        object = "CUoD memory order information has been gathered successfully.";
                        MOClass mOClass = CECMObject.getMOClassProxy((String)"com.ibm.hsc.websm.cec.CECMObject");
                        HSCLogUtils.logSystemEvent((short)2097, (String)object, new String[0], HSCLogUtils.getUserName(mOClass));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!IDebug.enabled) break block14;
                    System.out.println("\treturnHashtable :");
                    object = hashtable.keys();
                    while (object.hasMoreElements()) {
                        var2_2 = object.nextElement();
                        System.out.println("\t\t" + var2_2 + " --> " + hashtable.get(var2_2));
                    }
                }
                catch (Throwable throwable) {
                    try {
                        String string = "Failed to gather CUoD memory order information.";
                        MOClass mOClass = CECMObject.getMOClassProxy((String)"com.ibm.hsc.websm.cec.CECMObject");
                        HSCLogUtils.logSystemEvent((short)2098, string, new String[0], HSCLogUtils.getUserName(mOClass));
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    try {
                        HSCLogUtils.clientLog(throwable, HSCLogUtils._CECClassLogInfo);
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                    throw new HSCException(throwable);
                }
            }
            Object var7_10 = null;
            if (IDebug.enabled) {
                System.out.print("********************************");
                System.out.println("********************************");
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (IDebug.enabled) {
                System.out.print("********************************");
                System.out.println("********************************");
            }
            throw throwable;
        }
        return hashtable;
    }

    private void _cuodMemoryOrderInfo(Hashtable hashtable) throws Throwable {
        this._memoryInfo(hashtable);
    }

    private void _memoryInfo(Hashtable hashtable) throws Throwable {
        Vector vector = new Vector();
        Vector vector2 = new Vector(1);
        String[] stringArray = new String[]{};
        HscUtil.invokeCIMMethod(this.hostName, this.cecPath, CUOD_MEMORY_INFO, vector, vector2);
        if (IDebug.enabled) {
            IDebug.println((String)("outParam = " + vector2));
        }
        stringArray = ((Vector)((CIMProperty)vector2.firstElement()).getValue().getValue()).toArray(stringArray);
        hashtable.put("CUOD_AMOUNT_MEM_INSTALLED", stringArray[0]);
        hashtable.put("CUOD_AMOUNT_MEM_PERM_IN_USED", stringArray[1]);
        hashtable.put("CUOD_AMOUNT_MEM_NOT_PERM_IN_USED", stringArray[2]);
        hashtable.put("CUOD_AMOUNT_MEM_IMMED_IN_USED", stringArray[3]);
        hashtable.put("CUOD_MEM_ACT_IMMED_CONDITION", stringArray[4]);
        hashtable.put("CUOD_MEM_ACT_IMMED_TIME_REMAINING", stringArray[5]);
        hashtable.put("CUOD_MEM_RESOURCE_ID", stringArray[6]);
        hashtable.put("CUOD_MEM_SEQ_NUM", stringArray[7]);
        hashtable.put("CUOD_MEM_ENTRY_CHECK", stringArray[8]);
        hashtable.put("CUOD_CAPACITY_CARD_CCIN", stringArray[9]);
        hashtable.put("CUOD_CAPACITY_CARD_SERIAL_NUM", stringArray[10]);
        hashtable.put("CUOD_CAPACITY_CARD_UNIQUE_ID", stringArray[11]);
        hashtable.put("CUOD_SYSTEM_SERIAL_NUM", stringArray[12]);
        hashtable.put("CUOD_SYSTEM_TYPE", stringArray[13]);
        hashtable.put("CUOD_MEM_ACTIVATED", stringArray[14]);
        hashtable.put("CUOD_MEMORY_INCREMENT", stringArray[16]);
    }

    private void _activateImmedCPU(Integer n) throws Throwable {
        Vector<CIMProperty> vector = new Vector<CIMProperty>(1);
        Vector vector2 = new Vector();
        vector.setSize(1);
        vector.setElementAt(new CIMProperty(MOF_NUM_PROCS_TO_ACTIVATE, new CIMValue((Object)new UnsignedInt8((short)n.intValue()))), 0);
        HscUtil.invokeCIMMethod(this.hostName, this.cecPath, MOF_CUOD_PROCESSOR_ACTIVATE_IMMEDIATE, vector, vector2);
    }

    private void _activateImmedMemory(Integer n) throws Throwable {
        Vector<CIMProperty> vector = new Vector<CIMProperty>(1);
        Vector vector2 = new Vector();
        vector.setSize(1);
        vector.setElementAt(new CIMProperty(MOF_AMOUNT_MEMORY_TO_ACTIVATE, new CIMValue((Object)new UnsignedInt32((long)n.intValue()))), 0);
        HscUtil.invokeCIMMethod(this.hostName, this.cecPath, MOF_CUOD_MEMORY_ACTIVATE_IMMEDIATE, vector, vector2);
    }

    private void _disableActivateImmedCPU() throws Throwable {
        Vector vector = new Vector(1);
        Vector vector2 = new Vector();
        HscUtil.invokeCIMMethod(this.hostName, this.cecPath, MOF_CUOD_DISABLE_PROCESSOR_ACTIVATE_IMMEDIATE, vector, vector2);
    }

    private void _disableActivateImmedMemory() throws Throwable {
        Vector vector = new Vector(1);
        Vector vector2 = new Vector();
        HscUtil.invokeCIMMethod(this.hostName, this.cecPath, MOF_CUOD_DISABLE_MEMORY_ACTIVATE_IMMEDIATE, vector, vector2);
    }

    private void _manageOnOffCoDCPUs(Integer n) throws Throwable {
        Vector<CIMProperty> vector = new Vector<CIMProperty>(1);
        Vector vector2 = new Vector();
        vector.setSize(1);
        vector.setElementAt(new CIMProperty(MOF_NUM_PROCS_TO_ACTIVATE, new CIMValue((Object)new UnsignedInt32((long)n.intValue()))), 0);
        HscUtil.invokeCIMMethod(this.hostName, this.cecPath, MOF_MANAGE_ONOFF_COD_PROCESSORS, vector, vector2);
    }

    private void _onoffProcessorInfo(Hashtable hashtable) throws HSCException {
        Vector vector = new Vector();
        Vector vector2 = new Vector(1);
        String[] stringArray = new String[]{};
        try {
            HscUtil.invokeCIMMethod(this.hostName, this.cecPath, MOF_GET_ONOFF_PROCESSOR_INFO, vector, vector2);
            stringArray = ((Vector)((CIMProperty)vector2.firstElement()).getValue().getValue()).toArray(stringArray);
            hashtable.put("ONOFF_TOTAL_INSTALLED", stringArray[0]);
            hashtable.put("ONOFF_PROCS_PERM_IN_USE", stringArray[1]);
            hashtable.put("ONOFF_PROCS_IMMED_IN_USE", stringArray[17]);
            hashtable.put("CUOD_CPU_ACT_IMMED_CONDITION", stringArray[18]);
            hashtable.put("ONOFF_PROCS_PREV_ORDERED", stringArray[16]);
            hashtable.put("ONOFF_PROCS_IN_USE", stringArray[3]);
            hashtable.put("ONOFF_PROCS_PENDING", stringArray[4]);
            hashtable.put("ONOFF_PROCS_INCREMENT", stringArray[5]);
            hashtable.put("ONOFF_PROCS_GARDED", stringArray[2]);
            hashtable.put("ONOFF_STATE", stringArray[6]);
            hashtable.put("ONOFF_HOURS_REMAINING", stringArray[7]);
            hashtable.put("ONOFF_DAYS_REMAINING", stringArray[19]);
            hashtable.put("ONOFF_RESOURCE_ID", stringArray[8]);
            hashtable.put("ONOFF_CCIN_ID", stringArray[11]);
            hashtable.put("ONOFF_CCIN_SERIAL_NUM", stringArray[20]);
            hashtable.put("ONOFF_SEQUENCE_NUM", stringArray[9]);
            hashtable.put("ONOFF_ENTRY_CHECK", stringArray[10]);
            hashtable.put("ONOFF_UNIQUE_ID", stringArray[13]);
            hashtable.put("ONOFF_SYSTEM_SERIAL_NUM", stringArray[14]);
            hashtable.put("ONOFF_SYSTEM_TYPE", stringArray[15]);
        }
        catch (Throwable throwable) {
            if (IDebug.enabled) {
                throwable.printStackTrace();
            }
            throw new HSCException(throwable);
        }
    }
}

